c=======================================================================
c23456789012345678901234567890123456789012345678901234567890123456789012
c  tilt correction revisited - cf steve barrett
c  soft: le or ge
c  stiff: lt or gt
c=======================================================================
c
       program cip1b
c
       implicit none
       include 'cip1.inc'

       print *,'--------------------------------------------------'
       print *,'*cip1b: azi/inc  from  azi/inc/tindex'
       print *,'        no polefigure !'
       print *,'        maximum image size is ', n_maxsize
       print *,'        re-written for macosx and g77      june-06'
       print *,'        last update                       march-07'
       print *,'--------------------------------------------------'

       print *,' ***** calling control'
       call cip01control

       print *,'-------------------------------------------------'
       print *,' ***** calling readfiles'
       call cip02readfiles
       
c       print*,'azi = ',ichar(pixrot(1000,1))
c       print*,'inc = ',ichar(pixtilt(1000,1))
c       print*,'tindex = ',ichar(pixcirpol(1000))

       print *,'-------------------------------------------------'
       print *,' ***** calling convert2'
       call cip07convert2
       
c       print*,'azi = ',ichar(pixrot(1000,1))
c       print*,'inc corrected = ',ichar(pixresult(1000,1))
c       print*,'tindex = ',ichar(pixcirpol(1000))

c       print *,'-------------------------------------------------'
       print *,' ***** calling writefiles'
       call cip09writefiles

c             print *,'-------------------------------------------------'
c             print *,' ***** calling polefigure'
c      call cip10polefigure

       print *,'-------------------------------------------------'
       print *,' ***** calling ava'
       
       call cip11ava
       print *,'-------------------------------------------------'


       call exit
       end
c=======================================================================
c
       subroutine cip01control
c
c (a)  reads control data from control file: fn_control
c      the control file contains all input and output image names
c      and the names of 2 calibration files:
c      fn_calib_input and fn_calib_inclination
c
c (b)  reads calibration data from calibration files:
c      fn_calib_input and fn_calib_inclination
c

       implicit none
       include 'cip1.inc'

       integer i
       character*80 header
       
c (a)  read from control file

       write(out_unit,'(a)') ' name of controle file > '
       read(in_unit,'(a)') fn_control

       open(unit=ctrl_unit,file=fn_control,
     . status='old',form='formatted')

c--------input file names

       read(ctrl_unit,'(a)') header   ! headers in control file
       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') title

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,*) xdim,ydim
       
       itot=xdim*ydim

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,*) tilts,tilttype

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,*) back1,back2,flaresub,camcorr

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,*) aziref,incref

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_rot(1)

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_tilt(1)

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_cirpol

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_calib_input
       write(out_unit,'(1x,a)') fn_calib_input
       
       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_calib_inclination
       write(out_unit,'(1x,a)') fn_calib_inclination

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_pixclut

c-------output file names

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_result(1)

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_ava

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_cpf

       close(unit=ctrl_unit)



c (b)  read calibration data in file "fn_calib_input"

       open(unit=ctrl_unit,file=fn_calib_input,
     . status='old',form='formatted')

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,*) magenta

       read(ctrl_unit,'(a)') header
       do i=1,n_rot
       read(ctrl_unit,*) flare(i)
       enddo

       read(ctrl_unit,'(a)') header
       do i=lut_low,lut_up
       read(ctrl_unit,*) program_lut(i)
       enddo

       read(ctrl_unit,'(a)') header
       do i=lut_low,lut_up
       read(ctrl_unit,*) camera_lut(i)
       enddo

       close(unit=ctrl_unit)



c (b)  read thin section data in file "fn_calib_inclination"

       open(unit=ctrl_unit,file=fn_calib_inclination,
     . status='old',form='formatted')

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') mineral
       
       if(mineral.eq.'c') mineral='C'
       if(mineral.eq.'q') mineral='Q'

       if(mineral.ne.'C'.and.mineral.ne.'Q') 
     .        print *,' stop ! unknown mineral !'

       read(ctrl_unit,'(a)') header
       do i=lut_low,lut_up
       read(ctrl_unit,*) ampl_sine2_lut(i)
       enddo

       read(ctrl_unit,'(a)') header
       do i=lut_low,lut_up
       read(ctrl_unit,*) cirpol_sine2_lut(i)
       enddo

       close(unit=ctrl_unit)

       return
       end

c===========================================================================
c
       subroutine cip02readfiles

c      reads input images into linear arrays pixrot, pixtilt and pixcirpol
c
c      uses and contains source of                             cip_read_file
c      cip_read_file uses and contains source of cip_file_open_r, cip_get_file
c      cip_file_open_r uses and contains source of      cip_inquire
c

       include 'cip1.inc'

c      read input images

       call cip_read_file(fn_rot(1),xdim,ydim,pixrot(1,1))

       call cip_read_file(fn_tilt(1),xdim,ydim,pixtilt(1,1))

       call cip_read_file(fn_cirpol,xdim,ydim,pixcirpol)

       return
       end


c===========================================================================

       subroutine cip_read_file(filnam,ix,iy,buff)
       
c      opens image file: filnam and reads into linear buffer: buff

       character*(*) filnam
       character*1 buff(1)
       integer ix,iy

       integer iunit
       iunit = 3

       call cip_file_open_r(iunit,filnam)        ! open for read
       call cip_get_file(iunit,ix,iy,buff)
       close(unit=iunit)

       return
       end


c===========================================================================

       subroutine cip_file_open_r(iunit,filnam)
       
c      opens file: filnam for reading

       include 'cip1.inc'
       integer iunit,ilen
       character*(*) filnam

       integer trmlen
       integer rcl
       common/rectyp/rcl


       call cip_inquire(filnam,rcl)


         open(unit=iunit,file=filnam,status='old',access='direct',
     .   form='unformatted', recl=xdim)



       return
       end



c===========================================================================

       subroutine cip_inquire(filnam,rcl)

       character*(*) filnam
c      parameter n512 = 512

       parameter (idebug = 1)

       character*16 acc
       character*16 blk
       character*16 cc
       character*16 dir
       logical ex
       character*16 fm
       character*16 fmd
       character*16 org
       integer rcl
       character*16 rtype
       character*16 seq
       character*16 unf

       inquire(file=filnam,access=acc,direct=dir,exist=ex,
     . form=fm,recl=rcl,unformatted=unf,sequential=seq)

       if(idebug.eq.1) then

       print *,filnam
       if(.not.ex) then
              rcl=-1
              return
       endif
       endif

       return
       end


c===========================================================================

        subroutine cip_get_file(iunit,ix,iy,buff)

c      reads from unit iunit
c      recl = 512, fixed or ix fixed
c      iunit  : unit number
c      ix,iy  : image dimension
c      buff   : image data

       implicit none
c      parameter n512 = 512
       integer nrec,i,j,ia,ie,ix,iy,iunit

       character*1 buff(1)
       character*2048 line

       integer rcl
       common/rectyp/rcl

       if(rcl.eq.512) then

        nrec = ((ix*iy)/rcl)
        if ( mod((ix*iy),rcl) .ne. 0) nrec = nrec+1 

        do i = 1,nrec
         ia=(i-1)*512 + 1
         ie=ia+512-1
         read(iunit,rec=i)(buff(j),j=ia,ie)
        enddo

       else

        do i=1,iy
c       read(iunit,100,rec=i)line(1:ix)
        read(iunit,rec=i)line(1:ix)
         ia=(i-1)*ix
          do j=1,ix
           buff(ia+j) = line(j:j)
          enddo
        enddo

       endif

  100  format(a)

       return
       end

c=====================================================================
c
       subroutine cip03calibrate
c
c      calibrates the input data according to the data read from the 
c      calibration files: fn_calib_machine and fn_calib_section
c
c      uses and contains source of cip_calib_machine, cip_calib_back,
c      and cip_flare
c
c   update 18.9.95
c   new 6.98 brown: no calibration, direct calculation of inc from cirpol
c   assumes high values for bright pixels (= photoshop, ≠ nih image)
c   equip_lut is positive 1:1 linear

       implicit none
       include 'cip1.inc'

       call cip_calib_machine
       call cip_calib_back

       call cip_flare

       return
       end

c
c=====================================================================
c
       subroutine cip_calib_machine

c      performs calibrations using the equip_lut look up table
c      calibrations depend on recording equipment and lighting conditions
c      equip_lut is the lut for infrared narrow band interference filters
c
c      for kodak dcs200     dcs200.cal    _b and _od mode
c      for ikegami              ikegami.cal
c
c      cip_calib_machine returns absolute intensity values
c               0 =   0 % transmittance   (black)
c             255 = 100 % transmittance   (brightest)

       implicit none
       include 'cip1.inc'
       integer i,j

       itot=xdim*ydim

c      rotation images   1/99 leave without eos calib

       do i=1,n_rot
              do j=1,itot
              pixrot(j,i)= char(program_lut(ichar(pixrot(j,i))))
              pixrot(j,i)= char(camera_lut(ichar(pixrot(j,i))))
              enddo
       enddo


c      tilt images    1/99 leave without eos calib

       do i=1,n_tilt
              do j=1,itot
              pixtilt(j,i)= char(program_lut(ichar(pixtilt(j,i))))
              pixtilt(j,i)= char(camera_lut(ichar(pixtilt(j,i))))
              enddo
       enddo


c      circular polarization and background images   1/99 eos calib <<<<<<<

       do j=1,itot
       pixcirpol(j)= char(program_lut(ichar(pixcirpol(j))))
       if(camcorr.eq.1) pixcirpol(j) = 
     . char(camera_lut(ichar(pixcirpol(j)))) 
       pixback2(j)= char(program_lut(ichar(pixback2(j))))
       pixback2(j)= char(camera_lut(ichar(pixback2(j))))
       pixback1(j)= char(program_lut(ichar(pixback1(j))))
       pixback1(j)= char(camera_lut(ichar(pixback1(j))))
       enddo


       return
       end

c
c=========================================================================
c
       subroutine cip_calib_back

c      performs background corrections
c      back1 -> background subtraction(pixback1)  of rot and tilt images
c      back2-> background subtraction(pixback2) of cirpol
c      0=no subtraction; 1=subtraction


       implicit none
       include 'cip1.inc'
       integer i,j, diff, new, maxim, bminr, bmincp

c   subtract minimum (=bminr, bmincp) of background

       bminr=255
       bmincp=255
       do j=1,itot
       bminr= min(bminr,ichar(pixback1(j)))
       bmincp= min(bmincp,ichar(pixback1(j)))
       enddo
       
       do j=1,itot
       pixback1(j)= char(ichar(pixback1(j)) - bminr)
       pixback2(j)= char(ichar(pixback2(j)) - bmincp)
       enddo


       if(back1.eq.0) go to  100   ! no background corrections of rots 

       do i=1,n_rot
       do j=1,itot
       diff= ichar(pixrot(j,i))-ichar(pixback1(j))
       if(diff.lt.0) diff = 0
       pixrot(j,i)= char(diff)
       enddo
       enddo

       do i=1,n_tilt
       do j=1,itot
       diff= ichar(pixtilt(j,i)) - ichar(pixback1(j))
       if(diff.lt.0) diff = 0
       pixtilt(j,i)= char(diff)
       enddo
       enddo


100    continue

c   background of cirpol

       if(back2.eq.0) go to 200   !no background correction for cirpol

       do j=1,itot
       diff= ichar(pixcirpol(j)) - ichar(pixback2(j))
       if(diff.lt.0) diff = 0
       pixcirpol(j)= char(diff)
       enddo

200    continue

       return
       end


c
c=========================================================================
c
       subroutine cip_flare
c
c      performs flare correction:
c

       implicit none
       include 'cip1.inc'
       integer i, j, ipix, minmin(n_rot), koord
       integer ieqlut,imagenta

c
c   flaresub = 0     no flare correction
c   flaresub = 1     flare correction from flare(n_rot)
c

       if(flaresub.eq.0) return
c
c   correct flare-values using equip_lut
c
       do i=1,n_rot
       ieqlut=program_lut(flare(i))
       imagenta=program_lut(magenta)
              do j=1,itot
              ipix=ichar(pixrot(j,i))-ieqlut+imagenta
              if(ipix.le.0) ipix=0
              if(ipix.ge.255) ipix=255
              pixrot(j,i)=char(ipix)
       enddo
       enddo

       do i=1,n_tilt
         do j=1,itot
         ipix=ichar(pixtilt(j,i))-program_lut(flare(18))
     .    +program_lut(magenta)
         if(ipix.le.0) ipix=0
         if(ipix.ge.255) ipix=255
         pixtilt(j,i)=char(ipix) 
       enddo
       enddo
c
       return
       end

c=======================================================================
c
       subroutine cip04viewpix
c
c      is used for inspecting the 22 image planes of a given pixel
c      cip04_viewpix is ended by typing <ctrl>z
c      used for installation and testing
c      not used in regular application
c
c      uses cip_fit_poly (source in cip05_curfit)
c

       implicit none
       include 'cip1.inc'

       integer ix,iy,ivalue(n_rot+n_tilt),k, m1,m2,m3,m4,m5,i,ij
       integer cir

90     write(out_unit,'(a)') ' viewpix: x,y coordinates 
     .  (end = (0,0)) > '
       read(in_unit,*,end=99,err=90) ix,iy

       if(ix.le.0 .and. iy.le.0) go to 99

       if(ix.gt.xdim .or. iy.gt.ydim) then
       write(out_unit,'(a)') '-- !! coordinates out of range !!'
       write(out_unit,'(a,i4,a,i4,a)')
     . '-- !! should be (1<x<',xdim,') and (1<y<',ydim,')'
       goto 90
       endif

       k=ij(ix,iy)
       do i=1,n_rot
       ivalue(i) = ichar(pixrot(k,i))
       enddo
       do i=1,n_tilt
       ivalue(i+n_rot) = ichar(pixtilt(k,i))
       enddo

       call cip_fit_poly(ivalue,m1,m2,m3,m4,m5)

       write(out_unit,'(1x,a,18i4)')
     .  '-- rot ',(ivalue(i),i=1,n_rot)
       write(out_unit,'(1x,a,4i4)')
     .  '-- tilt',(ivalue(i+n_rot),i=1,n_tilt)
       write(out_unit,'(1x,a,3i4)')
     .  '-> max, min, ampltude:                ', m1,m2,(m1-m2)
       cir=ichar(pixcirpol(k))
       write(out_unit,'(1x,a,3i4)')
     .  '-> phase of max, of min, cirpol:      ', m3,m4,cir
       write(out_unit,'(1x,a,2i4)')
     .  '-> total diff., magenta :             ', m5, magenta

       goto 90

99     return
       end

c=========================================================================
c
       subroutine cip05curfit

c      performs curve fit of the 'n_rot' rotated images
c      at each pixel of xdim*ydim picture
c
c      uses and contains source of cip_fit_poly
c      cip_fit_poly uses gausz (source in cip99_utils)

       implicit none

       include 'cip1.inc'

       integer i,j,ivalue(n_rot+n_tilt)
       integer maxval,minval,maxphas,minphas,ierr

       do j=1,itot

         do i=1,n_rot
         ivalue(i) = ichar(pixrot(j,i))
         enddo

        call cip_fit_poly(ivalue,maxval,minval,maxphas,minphas,ierr)

        pixcurfit(j,nr_maxval)  = char(maxval)
        pixcurfit(j,nr_minval)  = char(minval)
        pixcurfit(j,nr_maxphas) = char(maxphas)
        pixcurfit(j,nr_minphas) = char(minphas)
        pixcurfit(j,nr_ierr)    = 
     .   char(ifix(255.*float(ierr)/float(maxval)))

       enddo ! j=1,itot (itot=xdim*ydim)

       return
       end

c========================================================================

       subroutine cip_fit_poly
     . (ivalue,maxval,minval,maxphas,minphas,ierr)

c      determines max/min value and phase
c      by 2nd order polynomial
c      uses gausz (source in cip_utils)

       implicit none
       include 'cip1.inc'




       real rmaxphas,rmaxval,delta,rminphas,rminval
       real dx, dx0, difsin, ampl, a0, xsine, phasinc

c      for subroutine gausz: 5 points, 2nd degree -> 3 coefficients

       real r(3*3),s(5*3),c(5*3)
       real x(3),d(5),p(5),f(5),sum

       integer ivalue(1),maxval,minval,maxphas,minphas,ierr
       integer i,j,il,iu


c      ierr =   0:  at start
c      ierr = 255:  magenta or fit out of bound-----------------omit---------!!!
c      ierr = 251:  3rd coeff.=0
c      ierr = 252:  if curve fit outside interval (0 to 255)
c      ierr = 253:  if forced minimum (at 90 deg.) > (absolute minimum-1)
c      1<ierr<250:  summed differences of sine fit, value > 250 are cut off

       ierr=0
       minval=255
       maxval=0

c      max and min of n_rot values -> maxval/minval
c      and integer phase value maxphas/minphas of maxval and minval

       do i=1,n_rot
        if(ivalue(i).le.minval) then
         minval = ivalue(i)
         minphas = i
        endif
        if(ivalue(i).ge.maxval) then
         maxval = ivalue(i)
         maxphas = i
        endif
       enddo

c      if(minval.gt.magenta .or. maxval.lt.magenta) ierr= 255

c      fits maximum through n_pt (=5) points at maxphas +/- 2 rot.increments
c      if maxval occurs at three consecutive steps, the last maxphas
c      is taken. should present no problem.

       do i= 1,5
       j = mod((maxphas-int(5/2)-2+i+n_rot),n_rot) + 1
       c(i) = float(maxphas+i-(5+1)/2)
       d(i) = float(ivalue(j))
       enddo

       do i = 1,5
       c(i+5) = c(i)
       c(i+10)= c(i)*c(i)
       c(i)   = 1.0
       enddo

c      fit 2nd degree polynomial to 5 points
c      solutions a=x(1), b=x(2), c=x(3)
c      for y = a + b*x + c *x2

       call gausz(r,s,c,x,d,p,f,5,3)

       rmaxval = float(maxval)

c      if c=0 maxphas -> rmaxphas

       if(x(3).eq. 0.0) then
         rmaxphas = float(maxphas)
         ierr=251
       else

c      tangent at max: f' = b + 2*c*x

         rmaxphas = -x(2)/(2.0*x(3))

c      if curve fit yields max outside of interval

          if(abs(float(maxphas) - rmaxphas) .gt. 2.0)  then
            rmaxphas = float(maxphas)
            ierr=252

c      if maximum inside interval

          else
           rmaxval  = x(1) + x(2)*rmaxphas + x(3)*(rmaxphas*rmaxphas)
           if(rmaxphas.gt.18.0) rmaxphas = rmaxphas - 18.0

          endif

       endif


c      determination of rminphas at maxphas+pi/2

       rminphas = rmaxphas+(0.5*float(n_rot))
       if(rminphas .gt. (float(n_rot)) )
     .        rminphas = rminphas - float(n_rot)


c      rminval = linear interpolation between adjacent values
c      note that rminval can be smaller than minval !!!

       il = int(rminphas)
       delta = rminphas - float(il)
       if(il.le.0) il=n_rot+il
       iu = il+1
       if(iu.gt.n_rot) iu=iu-n_rot

       rminval = float(ivalue(il))*(1.0-delta)+float(ivalue(iu))*delta
       if(rminval.gt.rmaxval) then
       rminval  = float(minval)
       ierr = 253
       endif

c      conversion to integer

       phasinc = 180.0/float(n_rot)
       maxval  = int(rmaxval+0.999)
       minval  = int(rminval+0.999)
       maxphas = int(rmaxphas*phasinc)
       minphas = int(rminphas*phasinc)

c      summed differences of n_rot values (ivalue(i))
c      from sine curve sin(2*x)

       if(ierr.gt.250) go to 100

       sum = 0.0
       a0  = 0.5*(rmaxval+rminval)
       ampl= 0.5*(rmaxval-rminval)
       dx0 = rmaxphas*phasinc - 45.0

       do i=1,n_rot
       dx = float(i*180/n_rot) - dx0
c                                  ! one complete sine for 180 !!
       dx = 2*dx
       xsine   = a0 + ampl*sin(dx*0.01745329)
       difsin = abs(float(ivalue(i))-xsine)
       sum = sum + difsin
       enddo

       ierr = max(1,min(250,int(sum)))

100    continue

       return
       end

c=======================================================================
c
       subroutine cip06writeprimary
c
c      writes primary result files
c      uses and contains source of                             cip_write_file
c      cip_write_file uses and contains sources of      cip_file_open_w, cip_put_file
c   writes err-file only
c
       implicit none
       include 'cip1.inc'
c
       integer i

       do i=n_curf,n_curf
       call cip_write_file(fn_curfit(i),xdim,ydim,pixcurfit(1,i))
       enddo

       return
       end


c=======================================================================

       subroutine cip_write_file(filnam,ix,iy,buff)

       implicit none

       character*(*) filnam
       character*1 buff(1)
       integer ix,iy

       integer iunit
       iunit = 3

       call cip_file_open_w(iunit,filnam,ix)
       call cip_put_file(iunit,ix,iy,buff)
       close(unit=iunit)

       return
       end


c=======================================================================

        subroutine cip_put_file(iunit,ix,iy,buff)

c      write on 'iunit'
c      recordlength recl = ix
c      iunit  : unit number
c      ix,iy  : image dimension
c      buff   : data buffer

       implicit none

       integer nrec,i,j,l,ia,ie,ix,iy,iunit

       character*1 buff(1)
       character*(3000) line

        do i = 1,iy

         ia=(i-1)*ix
c        ie=ia+ix-1

       do j=1,ix
       line(j:j)=buff(ia+j)
       enddo

c        write(iunit,'(a)',rec=i)(buff(j),j=ia,ie)
c        write(iunit,'(a)',rec=i) line(1:ix)
         write(iunit,rec=i) line(1:ix)
        enddo

       return
       end


c=====================================================================

       subroutine cip_file_open_w(iunit,filnam,width)

       integer iunit,ilen
       character*(*) filnam
       integer trmlen
       integer width

c      vax convention

       open(unit=iunit,file=filnam,status='new',access='direct',
     . form='unformatted',recl=width)

       return
       end


c========================================================================
c
       subroutine cip07convert2
c
c   update 14.7.95: harte bedingung fuer cip_correct_tilt
c   update 18.7.95: cut-offs an histogramm der amplituden
c   update 23.6.06: converts inc0 to inc using tindex
c
c      converts primary images to azimuth and inclination files
c      azimuth runs from north clockwise to south (0 < azi <=180)
c      inclination runs from zenith to down (0 < inc <=180)
c      direction     azi/inc              slightly up (30 deg. w/r horizontal)
c      n             180/ 90              180/120                0 -> 180
c      e              90/ 90               90/ 60                1 ->   1
c      s             180/ 90              180/ 60              180 -> 180    
c      w              90/ 90               90/120
c
c      uses and contains sources of cip_convert_primary, cip_correct_tilt
c

       implicit none
       include 'cip1.inc'

c      call cip_convert_primary
c      converts pixcurfit images to primary azimuth and inclination

       call cip_correct_tilt2

c      corrects inclination using tilt images
c      using azi inc0 tindex

       return
       end
c
c========================================================================
c
       subroutine cip_convert_primary

       implicit none
       include 'cip1.inc'
       integer*4 i,j,minampl,maxampl,nlo,nup,nlo1,nup1
       integer*4 nlo2,nup2,nlo5,nup5
       integer*4 maxhist
       integer*4 limit, ilo, iup, k
       integer*4 ihist(256)
       character*50 star

       do i=1,50
       star(i:i)='*'
       enddo


c      (1) conversion of maxphas to azimuth (0 < azi <= 180)

       do i=1,itot

       if(mineral.eq.'c') j = ichar(pixcurfit(i,nr_maxphas)) -135
       if(mineral.eq.'q') j = ichar(pixcurfit(i,nr_maxphas)) - 45


c              this assumes clockwise rotation of polarizers,
c              hence counterclockwise rotation of c-axes
c              quartz: north-pointing c-axis moves from magenta
c              to yellow to magenta to blue:
c              maximum brightness (maxphas) is at phas = 45.

        if(j.le.0) j = j + 180
        pixresult(i,nr_azi) = char(j)

       enddo



c      (2) conversion of maxampl to primary inclination:
c          inclination from zenith to horizontal (0 =< incl =< 90)
c      nr_incamp:  using amplitude (maxval-minval) of rotation images

       maxampl=0
       minampl=255

       do i=1,256
       ihist(i)=0
       enddo  

       do i=1,itot

       j = ichar(pixcurfit(i,nr_maxval))-ichar(pixcurfit(i,nr_minval))
       if(j.lt.0) j=0
       if(j.gt.255) j=255

       maxampl=max0(maxampl,j)
       minampl=min0(minampl,j)
       ihist(j+1)= ihist(j+1)+1

       pixresult(i,nr_incamp) = char(j)

       enddo

       ilo=0
       iup=0
       limit=xdim*ydim/100

       do i=1,256
       nlo1=i
       ilo=ilo+ihist(nlo1)
       if (ilo.ge.limit) go to 50
       enddo

50     continue

       do i=1,256
       nup1=257-i
       iup=iup+ihist(nup1)
       if (iup.ge.limit) go to 60
       enddo

60     continue

       ilo=0
       iup=0
       limit=xdim*ydim/50

       do i=1,256
       nlo2=i
       ilo=ilo+ihist(nlo2)
       if (ilo.ge.limit) go to 70
       enddo

70     continue

       do i=1,256
       nup2=257-i
       iup=iup+ihist(nup2)
       if (iup.ge.limit) go to 80
       enddo

80     continue

       ilo=0
       iup=0
       limit=xdim*ydim/20

       do i=1,256
       nlo5=i
       ilo=ilo+ihist(nlo5)
       if (ilo.ge.limit) go to 90
       enddo

90     continue

       do i=1,256
       nup5=257-i
       iup=iup+ihist(nup5)
       if (iup.ge.limit) go to 95
       enddo

95     continue


c      histogram

        do i=1,16
        do j=1,15
        ihist((i-1)*16+1)= ihist((i-1)*16+1)+ihist((i-1)*16+1+j)
        enddo
              ihist(i)= ihist((i-1)*16+1)
        enddo

       maxhist=0
       do i=1,16
       maxhist=max0(ihist(i),maxhist)
       enddo

       do i=1,16
       ihist(i)=ifix(float(ihist(i))/float(maxhist)*50.)
       enddo

       write(6,141)
141    format(/' inca:'/)
       do i=1,16
       j=16*i
c      write(6,140) 
140    format(' ')
       write(6,130) j, star(1:ihist(i))
130    format('+ ',i3,' ',a)
       enddo



       write(6,105)
105    format(/' amplitude image incamp')
       write(6,100) minampl,nlo1,nlo2,nlo5,nup5,nup2,nup1,maxampl
100    format(' 0-1-2-5-95-98-99-100 % = ',8i6)
103    write(6,101)
101    format(' input cut-off values (min,max) > ')
       read(5,102,err=103) nlo, nup
102    format(2i10)

       maxampl=nup-nlo

       do i=1,itot

       j=ichar(pixresult(i,nr_incamp))

       j=(j-nlo)*255/maxampl
       if(j.lt.0) j=0
       if(j.gt.255) j=255

       pixresult(i,nr_incamp) = char(ampl_sine2_lut(j))
c
c    ampl_direct is radial section of mono-sic: ampl(inc) for max ampl(azi)

       enddo

c             incamp is scaled between 0 and 90 degrees


c      (3) conversion of cirpol to primary inclination:
c          inclination from zenith to horizontal (0 =< incl =< 90)
c      nr_incpol:  using circular polarization image


       maxampl=0
       minampl=256

       do i=1,256
       ihist(i)=0
       enddo  

       do i=1,itot

       j=ichar(pixcirpol(i))

       maxampl=max0(maxampl,j)
       minampl=min0(minampl,j)
       ihist(j+1)= ihist(j+1)+1

       pixresult(i,nr_incpol) = char(j)

       enddo

       ilo=0
       iup=0
       limit=xdim*ydim/100

       do i=1,256
       nlo1=i
       ilo=ilo+ihist(nlo1)
       if (ilo.ge.limit) go to 250
       enddo

250    continue

       do i=1,256
       nup1=257-i
       iup=iup+ihist(nup1)
       if (iup.ge.limit) go to 260
       enddo

260    continue

       ilo=0
       iup=0
       limit=xdim*ydim/50

       do i=1,256
       nlo2=i
       ilo=ilo+ihist(nlo2)
       if (ilo.ge.limit) go to 270
       enddo

270    continue

       do i=1,256
       nup2=257-i
       iup=iup+ihist(nup2)
       if (iup.ge.limit) go to 280
       enddo

280    continue

       ilo=0
       iup=0
       limit=xdim*ydim/20

       do i=1,256
       nlo5=i
       ilo=ilo+ihist(nlo5)
       if (ilo.ge.limit) go to 290
       enddo

290    continue

       do i=1,256
       nup5=257-i
       iup=iup+ihist(nup5)
       if (iup.ge.limit) go to 295
       enddo

295    continue

c      histogram

        do i=1,16
        do j=1,15
        ihist((i-1)*16+1)= ihist((i-1)*16+1)+ihist((i-1)*16+1+j)
        enddo
              ihist(i)= ihist((i-1)*16+1)
        enddo

       maxhist=0
       do i=1,16
       maxhist=max0(ihist(i),maxhist)
       enddo

       do i=1,16
       ihist(i)=ifix(float(ihist(i))/float(maxhist)*50.)
       enddo

       write(6,142)
142    format(/' incp:'/)
       do i=1,16
       j=16*i
c      write(6,140) 
       write(6,130) j, star(1:ihist(i))
       enddo


       write(6,205)
205    format(/' inclination image incpol')
       write(6,200) minampl,nlo1,nlo2,nlo5,nup5,nup2,nup1,maxampl
200    format(' 0-1-2-5-95-98-99-100 % = ',8i6)
203    write(6,201)
201    format(' input cut-off values (min,max) > ')
       read(5,202,err=203) nlo, nup
202    format(2i10)


       maxampl=nup-nlo

       do i=1,itot

       j=ichar(pixresult(i,nr_incpol))

       j=(j-nlo)*255/maxampl
       if(j.lt.0) j=0
       if(j.gt.255) j=255


       pixresult(i,nr_incpol) = char(cirpol_sine2_lut(j))
c      pixresult(i,nr_incpol) = char(j)


c      now    incpol is scaled between 0 and 90 degrees

       enddo

       return
       end

c
c========================================================================
c
       subroutine cip_correct_tilt2

c      update 24.6.1996, 5.2.2013
c
c       number of tilt images used is given by tilts
c       tilttype: the type of tilting is as follows
c       for 2 tilts:
c       tilttype=0..  ->  w/r to initial, "compliant" tilting (...or....)
c       tilttype=1..  ->  w/r to initial, "stiff" tilting (...or....)
c       tilttype=012,112 soft/stiff for east up and west up
c       tilttype=041,141 (or 014,114) soft/stiff for east up and north up
c       for 4 tilts:
c       tilttype=0  ->  "soft" comparing eup to wup  and sup to nup
c       tilttype=1  ->  "stiff" comparing eup to wup  and sup to nup
c
c      correction is different for optically positive and negative minerals
c      'q' = quartz = positive
c      'c' = calcite = negative


       implicit none
       include 'cip1.inc'

       integer azi,inc0,inc,i,eup,sup,wup,nup,initial,tindex
       
c       print *,'convert2 correct_tilt2'

       do i=1,itot
c      do i=1000,1020

       azi     = ichar(pixrot(i,1))       ! derived azimuth image
       inc     = ichar(pixtilt(i,1))      ! primary inclination (0-90 deg.)
       tindex  = ichar(pixcirpol(i))      ! index
       
       if(tindex.gt.0) inc = 180 - inc   !   <<<<<<< 06.06   indicator !!!

       if (inc.gt.180) inc = inc - 180    ! just in case
       if (inc.le.0)   inc = inc + 180    ! inc should be (0 < inc <= 180)

       pixresult(i,1) = char(inc)
c      print*,'azi = ',ichar(pixrot(i,1)),azi
c      print*,'inc = ',ichar(pixtilt(i,1)),inc
c      print*,'tindex = ',ichar(pixcirpol(i)),tindex
c      print*,'-------------------------inc corr = ',ichar(pixresult(i,1))

       
       enddo

       return
       end




c=======================================================================
c
       subroutine cip09writefiles
c
c      writes the generated image files
c
c      uses cip_write_file (source in cip06_write_files_primary)
c
       implicit none
       include 'cip1.inc'
c
       integer i

       call cip_write_file(fn_result(1),xdim,ydim,pixresult(1,1))

       return
       end


c------------------------------------------------------
c****** functions and subroutines ******
c------------------------------------------------------
c--1
       subroutine clearm(a,nx,ny,val)
c
c   cleans matrix a of size nx,ny
c
       real a(nx,ny)
       do 100 i=1,nx
       do 100 j=1,ny
       a(i,j)=val
100    continue
       return
       end
c------------------------------------------------------
c--1-a
       subroutine baknet(a,nx,ny,back)
c
c   makes background around stereonet matrix
c   assumes zero at center
c
       dimension a(nx,ny)
       xint=2.00/float(nx)
       yint=2.00/float(ny)
       x0= -1.0+0.5*xint
       y0= -1.0+0.5*yint
       do 100 j=1,ny
       do 100 i=1,nx
       x=x0 + (i-1)*xint
       y=y0 + (j-1)*yint
       it= inside(x,y,0.,0.,1.)
       if(it.eq.1) a(i,j)=back
100    continue
       return
       end
c------------------------------------------------------
c--2/1
       subroutine poplups(azi,pinc,xs,ys)
c
c    puts poles on x-y plane, using upper hemisphere projection
c    equal area schmidt net
c
c    azi   in   azimuth 0 = north (=x), running clockwise, from 0 to 180
c    pinc  in   polar angle 0 = up, 90 = x-y plane, 180 = down
c    x,y   out  x,y coordinates,x increasing right, y increasing up.
c
       data pi/3.141592654/
       data root2/1.414213562/
       data factor/0.0174532925/
       a = azi*factor
       d = pinc*factor
       if(pinc.gt.90.) d=pi-d
c                                   polar angle !
c                                   r=sqrt(2)*sin(pi/4-dip/2)
c                                   in mentex 0 = 90 deg of dip
       r = root2*sin(0.5*d)
       xs = r*sin(a)
       ys = r*cos(a)
       if(pinc.gt.90.) xs = -xs
       if(pinc.gt.90.) ys = -ys
       return
       end
c------------------------------------------------------
c--2/2
       subroutine poplupw(azi,pinc,xs,ys)
c
c    puts poles on x-y plane, using upper hemisphere projection
c    wulff's net
c
c    azi   in   azimuth 0 = north (=x), running clockwise, from 0 to 180
c    pinc  in   polar angle 0 = up, 90 = x-y plane, 180 = down
c    x,y   out  x,y coordinates,x increasing right, y increasing up.
c
       data pi/3.141592654/
       data root2/1.414213562/
       data factor/0.0174532925/
       a = azi*factor
       d = pinc*factor
       if(pinc.gt.90.) d=pi-d
c                                   polar angle !
c                                   r=tan(pi/4-dip/2)
c                                   in mentex 0 = 90 deg of dip
       r = tan(0.5*d)
       xs = r*sin(a)
       ys = r*cos(a)
       if(pinc.gt.90.) xs = -xs
       if(pinc.gt.90.) ys = -ys
       return
       end
c------------------------------------------------------
c--3
       subroutine dinc(d,pinc,c)
c
c   converts relative densities into relative counts,
c   by multiplying the density and the area on the orientation sphere.
c   only the polar angle pinc is considered.
c
       data factor/0.0174532925/
       f= pinc*factor
       c = d*sin(f)
       return
       end
c------------------------------------------------------
c--4
       subroutine pimesh(x,y,x0,y0,xint,yint,nx,ny,x4n,y4n,ilow,jlow)
c
c   puts points of x-y plane into mesh of a matrix
c   returns 4 neighbouring grid points and indices of lower left corner
c
c   x,y       in   x-y coordinate of point (from -1 to +1)
c   x0,y0     in   x-y value of origin of matrix (-87.5/90.)
c   xint,yint in   x-y intervals between matrix points (5./90.)
c   nx,ny     in   size of matrix
c   x4n,y4n   out  vectors  containing x-y coordinates of neighbours
c   ilow,jlow out  indices of lower left neighbourhood point
c
       integer nx,ny
       dimension x4n(4),y4n(4)
       do 100 k=1,nx+1
       ilow=k
       xcomp=float(k-1)*xint+x0
       if(xcomp.ge.x) go to 101
100    continue
101    continue
       do 200 k=1,ny
       jlow=k
       ycomp=float(k-1)*yint+y0
       if(ycomp.ge.y) go to 201
200    continue
201    continue
       ilow=ilow-1
       jlow=jlow-1
       x4n(1)=xcomp-xint
       x4n(2)=xcomp
       x4n(3)=xcomp
       x4n(4)=xcomp-xint
       y4n(1)=ycomp-yint
       y4n(2)=ycomp-yint
       y4n(3)=ycomp
       y4n(4)=ycomp
       return
       end
c------------------------------------------------------
c--5
       subroutine distri(x,y,c,x4n,y4n,ilow,jlow,s,nx,ny)
c
c   distributes the relative counts of point (x,y) onto the neighbours
c   minimum number of neighbours 1, maximum 4, (icrit=0 -> exit)
c   relative count is split into no.of neighbours and weighted by
c   distance dist of point (x,y) to neighbours (x4n(4),y4n(4)).
c   values are added to matrix s.
c
c   x,y        in  x-y coordinate of point (from poplup)
c   c          in  relative counts of (x,y) (from dinc)
c   x4n,y4n    in  neighbourhood vectors (from pimesh)
c   ilow,jlow  in  indices of lower left neighbourhood point (from pimesh)
c   s      in/out  matrix of grid points
c   nx,ny      in  size of matrix s
c
       dimension s(nx,ny)
       dimension x4n(1),y4n(1)
       dimension is(4), dist(4)
       data is/0,0,0,0/
       data dist/0.,0.,0.,0./
       icrit=0
c
       do 100 k=1,4
       is(k)=inside(x4n(k),y4n(k),0.,0.,1.)
       icrit=icrit+is(k)
c                                                circle at (0,0)
c                                                radius = 1.00
       dist(k)= xydist(x,y,x4n(k),y4n(k))
100    continue
       if(icrit.eq.4) go to 9000
       dsum = 0.0
c
       do 200 k=1,4
       if(is(k).eq.0) dsum = dsum + dist(k)
200    continue
c
       do 300 k=1,4
       dist(k)=dist(k)/dsum
300    continue
c
       if(is(1).eq.0) s(ilow,  jlow)  =s(ilow,  jlow)  +c*dist(1)
       if(is(2).eq.0) s(ilow+1,jlow)  =s(ilow+1,jlow)  +c*dist(2)
       if(is(3).eq.0) s(ilow+1,jlow+1)=s(ilow+1,jlow+1)+c*dist(3)
       if(is(4).eq.0) s(ilow,  jlow+1)=s(ilow,  jlow+1)+c*dist(4)
c
9000   continue
       return
       end
c------------------------------------------------------
c--5-a
       function inside(x,y,xc,yc,r)
c
c   tests if point (x,y) is inside circle at (xc,yc) with radius r
c   returns 0 if inside: radius of point smaller or equal to r
c   returns 1 if outside: radius of point larger than r
c
       inside=0
       xd=x-xc
       yd=y-yc
       rtest = sqrt (xd*xd + yd*yd)
       if(rtest.gt.r) inside=1
       return
       end
c------------------------------------------------------
c--5-b
       function xydist(x1,y1,x2,y2)
c
c   calculates distance between two points (x1,y1) and (x2,y2)
c
       x=x1-x2
       y=y1-y2
       xydist=sqrt(x*x + y*y)
       return
       end
c------------------------------------------------------
c--6
       subroutine makrin(a,nxa,nya,b,nxb,nyb,iring)
c
c   makes a ring around the stereonet.
c   creates matrix b which contains a (= matrix s of stereonet)
c   plus a ring around the stereonet which is used for contouring
c
c   a(nxa,nya) in    matrix with stereonet
c   b(nxb,nyb) out   matrix with stereonet and ring
c   iring      in    width of ring, e.g. iring = 2 ->
c                                   shift of center (x0,y0) = 2
c                                   nxb,nyb = nxa,nya + 4
c
       dimension a(nxa,nya), b(nxb,nyb)
c      xint=2.00/float(nxa)
c      yint=2.00/float(nya)
c      x0= -0.5*xint
c      y0= -0.5*yint
       xint=5./90.
       yint=5./90.
       x0=-87.5/90.
       y0=-87.5/90.
c
       call clearm(b,nxb,nyb,255.0)
       do 100 j=1,nya
       do 100 i=1,nxa
       i2=i+1
       j2=j+1
       b(i2,j2) = a(i,j)
100    continue
       ri=1.0
       ro=1.1
c      ro=ri+float(2*iring)/float(nxb)
c                                      (2*iring),(nxb) are diameters
       do 200 j=1,nyb
       do 200 i=1,nxb
       call findxy(i,j,x0,y0,xint,yint,x,y)
       itest=inring(x,y,0.,0.,ri,ro)
       if(itest.eq.0) call findop(x,y,0.,0.,1.,xop,yop)
       if(itest.eq.0) call colect(xop,yop,x0,y0,xint,yint,nx,ny,a,fictc)
       b(i,j) = fictc
200    continue
       return
       end
c------------------------------------------------------
c--6-a
       subroutine findxy(i,j,x0,y0,xint,yint,x,y)
c
c   finds x-y values of matrix point
c
c   i,j       in  indices
c   x0,y0     in  x-y values at origin of matrix
c   xint,yint in  x-y intervals between matrix points
c   x,y       out x-y coordinates of matrix point (i,j)
c
       x=x0 + (i-1)*xint
       y=y0 + (j-1)*yint
       return
       end

c------------------------------------------------------
c--6-b
       function inring(x,y,xc,yc,ri,ro)
c
c   tests if point (x,y) is inside ring at (xc,yc)
c   with inner radius ri and outer radius ro
c   returns 0 if within ring:
c   radius of point larger than ri and smaller or equal to ro
c   returns 1 if outside ring:
c   radius of point smaller or equal to ri and larger than ro
c
       inring=0
       rtest = sqrt (x*x + y*y)
       if(rtest.le.ri.or.rtest.gt.ro) inring=1
       return
       end
c------------------------------------------------------
c--6-c
       subroutine findop(x,y,xc,yc,r,xop,yop)
c
c   finds x-y coordinates of pole on opposite side of pole figure
c
c   x,y    in  x-y coordinates of point
c   x0,y0  in  x-y coordinates of centerpoint
c   r      in  radius of stereonet
c   xop,yop out  x-y coordinates of opposing point:
c                pole with pincout = -pincin
c
       xd=x-xc
       yd=y-yc
c                                  rt = radius of (x,y)
c                                  rn = radius of (xop,yop)
       rt=sqrt(xd*xd + yd*yd)
       dr=rt-r
       rn=r-dr
       fac= -rn/rt
       xop= fac*x
       yop= fac*y
       return
       end
c------------------------------------------------------
c--6-d
       subroutine colect(x,y,x0,y0,xint,yint,nx,ny,s,fictc)
c
c   collects from the neighbouring grid points of a point (x,y)
c   the relative counts, and attributes them to (x,y) accoring to the
c   distance of (x,y) from (x4n,y4n).
c   inverse of distri
c
c   x,y        in  x-y coordinate of point (from poplup)
c   x0,y0      in  x-y coordinates of origin of matrix s
c   xint,yint  in  x-y intervals in matrix s
c   nx,ny      in  size of matrix s
c   s          in  matrix of grid points
c   fictc     out
c
c      dimension s(nx,ny)
       dimension s(1,1)
       dimension x4n(4),y4n(4)
       dimension dist(4)
       dimension itest(4)
       fictc=0.0
c
       call pimesh(x,y,x0,y0,xint,yint,nx,ny,x4n,y4n,ilow,jlow)
c
       do 100 k=1,4
       itest(k)=inside(x4n(k),y4n(k),0.,0.,1.)
c                                                circle at (0,0)
c                                                radius = 1.00
       dist(k)= xydist(x,y,x4n(k),y4n(k))
100    continue
c
       dsum = 0.0
       do 200 k=1,4
       if(itest(k).eq.0) dsum = dsum + dist(k)
200    continue
c
       do 300 k=1,4
       dist(k)=dist(k)/dsum
300    continue
c
       if(itest(1).eq.0) fictc = fictc + s(ilow,jlow)*dist(1)
       if(itest(2).eq.0) fictc = fictc + s(ilow+1,jlow)*dist(2)
       if(itest(3).eq.0) fictc = fictc + s(ilow+1,jlow+1)*dist(3)
       if(itest(4).eq.0) fictc = fictc + s(ilow,jlow+1)*dist(4)
c
9000   continue
       return
       end



c------------------------------------------------------
c--7
       subroutine unifco(s,n1020,nx,ny,smax)
c
c   scales values of matrix of stereonet such that they are in
c   mulitples of uniform
c   for origin of stereonet in center of matrix cell
c   the number of occupied points n1020 = 1020.
c   for origin of stereonet on grid point n1020 = 1009.
c
c   the maximum value in matrix s (after normalization) is printed
c   and returned.
c
       dimension s(nx,ny)
       sum = 0.0
       smax= 0.0
       do 100 i=1,nx
       do 100 j=1,ny
       sum = sum + s(i,j)
100    continue
       do 200 i=1,nx
       do 200 j=1,ny
       s(i,j)= (n1020*s(i,j))/sum
       smax=amax1(smax,s(i,j))
200    continue
       do 300 i=1,nx
       do 300 j=1,ny
       if(s(i,j).ge.smax) write(6,500) i,j,s(i,j)
500    format('-> maximum of polefigure is at (',i2,',',i2,'): ',f12.5)
300    continue
       return
       end
c=================================================
c   rotations
c
c------------------------------------------------------
       subroutine polxyz(azi,dip,x,y,z)
c
c   converts polar representation into x-y-z coordinates
c   takes any range of azi and dip
c   azi clockwise from 0 (=n)(=+x) to 180 (=s)(=-x)
c   dip from 0 (=up)(=+z) to 180 (=down)(=-z)
c
       data pi/3.141592654/
       data factor/0.0174532925/
       p=factor*dip
       z  = cos(p)
       rpl= sin(p)
       a= factor*azi
       x=  cos(a)*rpl
       y= -sin(a)*rpl
c      write(6,100) azi,dip,a,d,x,y,z
c100   format(' inside polxyz: azi,dip,a,d,x,y,z: '/7(f9.4,1x))
       return
       end
c------------------------------------------------------
       subroutine polxyzm(azi,dip,x,y,z)
c
c   mentex adapted
c   converts polar representation into x-y-z coordinates
c   takes any range of azi and dip
c   azi clockwise from 0 (=n)(=+x) to 360 (=n)(=+x)
c   dip from 0 (=up)(=+z) to 90 (=horizontal)(=x-y plane
c
       data pi/3.141592654/
       data factor/0.0174532925/
       p=factor*dip
       a= factor*azi
       z  = cos(p)
       rpl= sin(p)
       x=  cos(a)*rpl
       y= -sin(a)*rpl
c      write(6,100) azi,dip,a,d,x,y,z
c100   format(' inside polxyzm: azi,dip,a,d,x,y,z: '/7(f9.4,1x))
       return
       end
c------------------------------------------------------
       subroutine xyzpol(x,y,z,azi,dip)
c
c   converts x-y-z coordinates into polar representation
c   returns two ranges of azi and dip
c   azi clockwise from 0 (=n)(=+x) to 180 (=s)(=-x)
c   dip from 0 (=up)(=+z) to 180 (=down)(=-z)
c
       data factor/57.29577951/
       data pi,pihalf,twopi/3.141592654,1.5707963,6.2831853/
       d  = acos(z)
       a  = pihalf
        if(x.ne.0.) a = atan(-y/x)
c
       if(x.lt.0.) a = a + pi
c
       azi= factor*a
       dip= factor*d
       if(azi.lt.0.) dip = 180.-dip
       if(azi.lt.0.) azi = azi + 180.
       if(azi.gt.180.) dip = 180. - dip
       if(azi.gt.180.) azi = azi - 180.
c      write(6,100) x,y,z,a,d,azi,dip
c100   format(' inside xyzpol: x,y,z,a,d,azi,dip: '/(7f9.4,1x))
       return
       end
c------------------------------------------------------
       subroutine xyzpolm(x,y,z,azi,dip)
c
c   mentex adapted
c   converts x-y-z coordinates into polar representation
c   returns two ranges of azi and dip
c   azi clockwise from 0 (=n)(=+x) to 360 (=n)(=+x)
c   dip from 0 (=up)(=+z) to 90 (=horizontal)(=x-y plane)
c
       data factor/57.29577951/
       data pi,pihalf,twopi/3.141592654,1.5707963,6.2831853/
       d  = acos(abs(z))
       a  = pihalf
        if(x.ne.0.) a = atan(-y/x)
c
       if(x.lt.0.) a = a + pi
       if(z.lt.0.) a = a + pi
       if(a.lt.0.) a = a + twopi
       if(a.gt.twopi) a = a-twopi
c
       azi= factor*a
       dip= factor*d
c
c      write(6,100) x,y,z,a,d,azi,dip
c100   format(' inside xyzpolm: x,y,z,a,d,azi,dip: '/(7f9.4,1x))
       return
       end
c------------------------------------------------------
       subroutine dircos(xg,yg,cx,cy,cz)
c
c   converts coordinates of schnmidt net to direction cosines
c
       data factor/57.29577951/
       data root2/1.414213562/
       data pi,pihalf,twopi/3.141592654,1.5707963,6.2831853/
c
       r=sqrt(xg*xg+yg*yg)
       d=2.*asin(r/root2)
c
       a  = pihalf
        if(yg.ne.0.) a = atan(xg/yg)
c
       if(yg.lt.0.) a = a + pi
       if(a.lt.0.) a = a + twopi
c
       cz  = cos(d)
       rpl= sin(d)
       cx=  cos(a)*rpl
       cy= -sin(a)*rpl
c
       return
       end
c------------------------------------------------------
       subroutine angdif(cx,cy,cz,px,py,pz,sin)
c
c   calculates angular difference, from direction cosines
c   returns sine of difference
c
       c=cx*px+cy*py+cz*pz
       sin=sqrt(1.-c*c)
       return
       end
c------------------------------------------------------
       subroutine rotz(x,y,z,a)
c
c   rotates point (px,py,pz) about angle a in x-y plane, about z
c
       data factor/0.0174532925/
       an=a*factor
       cosa=cos(an)
       sina=sin(an)
       xn= cosa*x - sina*y
       yn= sina*x + cosa*y
       x=xn
       y=yn
       return
       end

c------------------------------------------------------
       subroutine rotx(x,y,z,a)
c
c   rotates point (px,py,pz) about angle a in y-z plane, about x
c
       data factor/0.0174532925/
       an=a*factor
       cosa=cos(an)
       sina=sin(an)
       yn= cosa*y - sina*z
       zn= sina*y + cosa*z
       y=yn
       z=zn
       return
       end
c------------------------------------------------------
       subroutine tilt(x,y,z,ax,an)
c
c   tilts point about horizontal tilt axis
c
       call rotz(x,y,z,ax)
c      print *,' tilt/rotz1: x,y,z: ',x,y,z
       call rotx(x,y,z,-an)
c      print *,' tilt/rotx: x,y,z: ',x,y,z
       call rotz(x,y,z,-ax)
c      print *,' tilt/rotz2: x,y,z: ',x,y,z
       return
       end
c
c------------------------------------------------------------------
       function trmlen(s)
c      determine actual length of string s
c
       character *(*) s
       l=len(s)
       do 10 k=l,1,-1
       lg=k
       if(s(k:k).ne.' ') goto 99
   10  continue
       lg=0
   99  trmlen=lg
       return
       end
c
c------------------------------------------------------------------
       function mlen(s)
c      determine actual length of string s
c
       character *(*) s
       l=len(s)
       do 10 k=l,1,-1
       lg=k
       if(s(k:k).ne.' ') goto 99
   10  continue
       lg=0
   99  mlen=lg
       return
       end
c
c===============================================================

       subroutine cip11ava
c
c      produces ava using the colour lookup table clut
c      uses and contains the source of cip_clut
c      uses cip_write_file (source in cip06_write_files_primary)
c      to write rgb non-interleaved colour image: fn_ava
c


       implicit none
       include 'cip1.inc'

       integer*4 azi,inc,i,j, jj

c
c  reads square clut (fn_pixclut:  selfmade.clut)
c

       jj=xdim
       xdim=180
       call cip_read_clut
       xdim=jj

       do i=1,itot
       azi = ichar(pixrot(i,1))
       inc = ichar(pixresult(i,1))
c
c   polamp via cip.inc: common /pol_or_amp/polamp
c
       do j=1,3
       pixava(i+(j-1)*itot) = clut(j,inc,azi)
       enddo
       enddo

       call cip_write_file(fn_ava,xdim,3*ydim,pixava)

       return
       end

c===============================================================

       subroutine cip_read_clut
c
c      reads the colour lookup table clut from
c      a 180*180 rgb (non-interleaved) picture file
c      data are in stereo graphic projection (diameter = 180) 
c

       implicit none
       include 'cip1.inc'

       integer*4 j,i,ipix,jpix,ij,jj
       integer*4 stereox,stereoy
       integer len
       integer mlen

       call cip_read_file(fn_pixclut,n_stereo,3*n_stereo,pixclut)

       do i=1,n_stereo
       do j=1,n_stereo

       do jj=1,3
       clut(jj,j,i) = pixclut(i + (j-1)*n_stereo + (jj-1)*nn_stereo)
       enddo
       
       enddo
       enddo
       
       
       len = mlen(fn_pixclut)
       
       
       if (fn_pixclut(len-2:len).eq.'pol'.or.
     . fn_pixclut(len-2:len).eq.'pol')
     . call cip_convert_clut       


       return
       end

c==================================================================
       subroutine cip_convert_clut
c
c    converts pol type clut to clut if name of clut ends with .pol
c

       implicit none
       include 'cip1.inc'
       
       integer*4 j,i,ipix,jpix,ij,jj
       integer*4 lx,ly
       integer*4 azi,inc
       real x,y

       character*1 clut2(3,n_stereo,n_stereo)
       
       do i=1,n_stereo
       do j=1,n_stereo

       do jj=1,3
       clut2(jj,j,i) = clut(jj,j,i)
       enddo
       
       enddo
       enddo
       
c                          clut(channel, inc, azi)      
c                          clut(   jj  ,  j ,  i )      
c                          clut(   jj  , ly , lx )      
       
       
       do lx=1,n_stereo   
       do ly=1,n_stereo
       
c===============================================================

       if(ly.le.90) then
       
       x=sin(float(lx)*0.0174532925) * float(ly)
       y=cos(float(lx)*0.0174532925) * float(ly)
       i=90+ifix(x)
       j=90-ifix(y)
       
       else
       
       x=sin(float(lx)*0.0174532925) * float(180-ly)
       y=cos(float(lx)*0.0174532925) * float(180-ly)
       i=90-ifix(x)
       j=90+ifix(y)
       
       endif


c===============================================================

       do jj=1,3
       clut(jj,ly,lx) = clut2(jj,j,i)
       enddo
       
       enddo
       enddo



       do i=1,n_stereo
       do j=1,n_stereo

       do jj=1,3
       pixclut(i + (j-1)*n_stereo + (jj-1)*nn_stereo) = clut(jj,j,i)
       enddo
       
       enddo
       enddo
       
       
       call cip_write_file
     .  ('convert.clut.raw',n_stereo,3*n_stereo,pixclut)
       
       
       
       return
       end
       

c
c======================================================================
c
       subroutine cip_angle(p,q,n,a)

c      uses the acute angle

       dimension p(n),q(n)
       call angle(p,q,n,a)
       if(a.gt.90.00) a = 180. - a
       return
       end
c
c======================================================================
c
       subroutine angle(p,q,n,a)

c   input: vector p and q of dimension n
c   returns angle in degrees
c
       dimension p(n), q(n)
       data factor/57.29577951/
c                               conversion from radian to degree
       s = scalp(p,q,n)
       t = vecm(p,n)
       r = vecm(q,n)
       arg = s/(t*r)
       if(abs(arg).gt.1.000) then
       a = 0.00
       else
       a = factor*acos(arg)
       endif
       return
       end
c
c---------------------------------------------------------------
       function scalp(p,q,n)
c
c   input: vector p and q of dimension n
c   returns scalar product
c
       dimension p(n), q(n)
       scalp=0.
       do 10 i=1,n
       scalp = scalp + p(i)*q(i)
10     continue
       return
       end
c
c---------------------------------------------------------------
       function vecm(p,n)
c
c   input: vector p of dimension n
c   returns vector magnitude
c
       dimension p(n)
       vecm = sqrt(scalp(p,p,n))
       return
       end

c
c======================================================================
c
c        integer function trmlen(s)
c
c       determines length of string s
c
c        character *(*) s
c        l=len(s)
c        do 10 k=l,1,-1
c        lg=k
c        ivalue=ichar(s(k:k))
c        if(.not.(ivalue.eq.32.or.ivalue.eq.0)) goto 99
c   10   continue
c        lg=0
c   99   trmlen=lg
c        return
c        end
c
c======================================================================

       integer function ij(ix,iy)

c      locates 2-d pixel in 1-d array

       include 'cip1.inc'

       ij = (iy-1)*xdim + ix
       return
       end


c======================================================================

c     subroutine gausz  /  ciba-geigy photochemie ag       semini
c                                       date  26.2.1972
c                                       version 01  modification 00
c        c(n*m)  input:  linearly independent variables
c        d(n)    input:  variables (measured values)
c        x(m)    output: coefficients
c        p(n)    output: fitted variables
c        f(n)    output: errors
c        r(m*m)  internal
c        s(n*m)  internal

      subroutine gausz(r,s,c,x,d,p,f,n,m)

      dimension r(1),s(1),c(1),x(1),d(1),p(1),f(1)
      if(n-m) 4,10,10
    4 llp=6
      write(llp,9)
    9 format(1h ,'*** gausz-error: n<m')
      return

c     orthogonalization after schmidt

   10 z=0.0
      do 20 i=1,n
   20 z=z+c(i)*c(i)
      z=sqrt(z)
      do 30 i=1,n
   30 s(i)=c(i)/z
      r(1)=z
      if (m-2) 45,35,35
   35 do 40 k=2,m
      kk=k-1
      do 50 i=1,kk
      z=0.0
      do 60 l=1,n
      is=n*(i-1)+l
      ic=n*(k-1)+l
   60 z=z+s(is)*c(ic)
      ir=m*(k-1)+i
      r(ir)=z
      ir=m*(i-1)+k
      r(ir)=0.0
   50 continue
      do 70 i=1,n
      ic=n*(k-1)+i
      z=c(ic)
      do 80 l=1,kk
      is=n*(l-1)+i
      ir=m*(k-1)+l
   80 z=z-r(ir)*s(is)
      is=n*(k-1)+i
      s(is)=z
   70 continue
      z=0.0
      do 90 i=1,n
      is=n*(k-1)+i
   90 z=z+s(is)*s(is)
      z=sqrt(z)
      do 100 i=1,n
      is=n*(k-1)+i
  100 s(is)=s(is)/z
      ir=m*(k-1)+k
      r(ir)=z
   40 continue
   45 do 110 k=1,m
      z=0.0
      do 115 i=1,n
      is=n*(k-1)+i
  115 z=z+s(is)*d(i)
      p(k)=z
  110 continue

c     back substitution

      ir=m*(m-1)+m
      x(m)=p(m)/r(ir)
      if(m-2) 140,112,112
  112 mm=m-1
      do 120 k=1,mm
      mk=m-k
      z=p(mk)
      do 130 i=1,k
      mi=mk+i
      ir=m*(mi-1)+mk
  130 z=z-r(ir)*x(mi)
      ir=m*(mk-1)+mk
  120 x(mk)=z/r(ir)
  140 continue
      do 160 j=1,n
      p(j)=0.0
      do 150 k=1,m
      ic=n*(k-1)+j
      p(j)=p(j)+c(ic)*x(k)
  150 continue
      f(j)=p(j)-d(j)
  160 continue
      return
      end
